package com.hero.objects.powers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class MissileDeflection extends Power {

	private static String xmlID = "MISSILEDEFLECTION";

	public MissileDeflection(Element root) {
		super(root, MissileDeflection.xmlID);
	}

	@Override
	public double getActiveCost() {
		if ((GenericObject.findObjectByID(getAssignedAdders(), "REFLECTION") != null)
				&& (GenericObject.findObjectByID(getAssignedModifiers(),
						"RANGED") != null)) {
			ArrayList<Adder> orig = getAssignedAdders();
			ArrayList<Adder> temp = new ArrayList<Adder>();
			double reflectionCost = 0;
			for (Adder ad : orig) {
				if (ad.getXMLID().equals("REFLECTION")
						|| ad.getXMLID().equals("ANYTARGET")) {
					reflectionCost += ad.getTotalCost();
					continue;
				}
				temp.add(ad);
			}
			setAssignedAdders(temp);
			double ret = super.getActiveCost();
			setAssignedAdders(orig);
			// now figure the reflection...
			ArrayList<Modifier> orig2 = getAssignedModifiers();
			ArrayList<Modifier> temp2 = new ArrayList<Modifier>();
			for (Modifier ad : temp2) {
				if (ad.getXMLID().equals("RANGED")) {
					continue;
				}
				temp2.add(ad);
			}
			Adder ad = new Adder();
			ad.setBaseCost(reflectionCost);
			ad.setSelected(true);
			ad.setAssignedModifiers(temp2);
			ret += ad.getActiveCost();
			return ret;
		}

		return super.getActiveCost();
	}

	@Override
	public double getActiveCost(String excludeID) {
		if ((GenericObject.findObjectByID(getAssignedAdders(), "REFLECTION") != null)
				&& (GenericObject.findObjectByID(getAssignedModifiers(),
						"RANGED") != null)) {
			ArrayList<Adder> orig = getAssignedAdders();
			ArrayList<Adder> temp = new ArrayList<Adder>();
			double reflectionCost = 0;
			for (Adder ad : orig) {
				if (ad.getXMLID().equals("REFLECTION")
						|| ad.getXMLID().equals("ANYTARGET")) {
					reflectionCost += ad.getTotalCost();
					continue;
				}
				temp.add(ad);
			}
			setAssignedAdders(temp);
			double ret = super.getActiveCost(excludeID);
			setAssignedAdders(orig);
			// now figure the reflection...
			ArrayList<Modifier> orig2 = getAssignedModifiers();
			ArrayList<Modifier> temp2 = new ArrayList<Modifier>();
			for (Modifier ad : orig2) {
				if (ad.getXMLID().equals("RANGED")) {
					continue;
				}
				temp2.add(ad);
			}
			Adder ad = new Adder();
			ad.setBaseCost(reflectionCost);
			ad.setSelected(true);
			ad.setAssignedModifiers(temp2);
			ret += ad.getActiveCost(excludeID);
			return ret;
		}

		return super.getActiveCost(excludeID);
	}

	@Override
	public String getDamageDisplay() {
		return "";
	}

	@Override
	public String getRange() {
		getRangeValue(); // just a safety
		return super.getRange();
	}

	@Override
	public int getRangeValue() {
		if (GenericObject.findObjectByID(getAssignedModifiers(), "ADJACENTHEX") != null) {
			return 0;
		} else if (GenericObject
				.findObjectByID(getAssignedModifiers(), "RANGE") != null) {
			String orig = range;
			range = "Yes";
			int ret = super.getRangeValue();
			range = orig;
			return ret;
		}

		return super.getRangeValue();
	}

	@Override
	public String getTarget() {
		if (GenericObject.findObjectByID(getAssignedAdders(), "REFLECTION") != null) {
			return "DCV";
		} else {
			return super.getTarget();
		}
	}
}